<?php
/**
 * STREAM BOT - MASTER ADMIN + USER AGENT PRESETS
 * Location: /home/uk247mediahost/public_html/admin.php
 */

error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);
ini_set('display_errors', 1);

$baseDir = "/home/uk247mediahost";
$files = [
    'proxies'   => "$baseDir/proxies.txt",
    'agents'    => "$baseDir/user_agents.txt",
    'streams'   => "$baseDir/streams.txt",
    'config'    => "$baseDir/bot_config.json",
    'cron_log'  => "$baseDir/cron_log.txt",
    'success'   => "$baseDir/successful_connections.log",
    'failed'    => "$baseDir/failed_connections.log",
    'error_log' => "$baseDir/cron_error.log"
];

// Preset Demo User Agents
$demoAgents = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36\n" .
"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\n" .
"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36\n" .
"Mozilla/5.0 (iPhone; CPU iPhone OS 17_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.1 Mobile/15E148 Safari/604.1\n" .
"Mozilla/5.0 (iPad; CPU OS 17_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.1 Mobile/15E148 Safari/604.1\n" .
"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:121.0) Gecko/20100101 Firefox/121.0\n" .
"Mozilla/5.0 (Macintosh; Intel Mac OS X 14.1; rv:120.0) Gecko/20100101 Firefox/120.0\n" .
"Mozilla/5.0 (Android 14; Mobile; rv:120.0) Gecko/120.0 Firefox/120.0\n" .
"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0\n" .
"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Mobile Safari/537.36";

$msg = "";

// --- ACTION HANDLERS ---
if (isset($_GET['action'])) {
    $action = $_GET['action'];
    if ($action === 'fix_perms') {
        shell_exec("chmod 755 $baseDir && chmod 644 $baseDir/*.txt $baseDir/*.json $baseDir/*.log");
        $msg = "✅ Permissions repaired.";
    }
    if ($action === 'stop_bot') {
        shell_exec("pkill -f stream_bot.php");
        $msg = "🛑 Bot process terminated.";
    }
    if ($action === 'start_bot') {
        shell_exec("php $baseDir/stream_bot.php > /dev/null 2>&1 &");
        $msg = "🚀 Bot started in background.";
    }
}

// --- SAVE HANDLER ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_all'])) {
    @file_put_contents($files['proxies'], trim((string)$_POST['proxy_data']));
    @file_put_contents($files['streams'], trim((string)$_POST['stream_data']));
    @file_put_contents($files['agents'],  trim((string)$_POST['agent_data']));
    @file_put_contents($files['config'],  json_encode(['min_L' => (int)$_POST['min_L'], 'max_L' => (int)$_POST['max_L'], 'min_D' => (int)$_POST['min_D'], 'max_D' => (int)$_POST['max_D']]));
    $msg = "💾 All data and presets saved.";
}

// --- DATA LOADING ---
$proxies = @file_get_contents($files['proxies']) ?: "";
$streams = @file_get_contents($files['streams']) ?: "";
$agents  = @file_get_contents($files['agents']) ?: $demoAgents; // Use presets if file is empty
$config  = json_decode(@file_get_contents($files['config']), true) ?: ['min_L'=>4,'max_L'=>9,'min_D'=>60,'max_D'=>300];

$is_running = shell_exec("ps aux | grep stream_bot.php | grep -v grep");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UK247 Master Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root { --bg: #0d1117; --card: #161b22; --border: #30363d; --accent: #58a6ff; --neon: #4ade80; }
        body { background-color: var(--bg); color: #c9d1d9; font-family: sans-serif; }
        .navbar { background: var(--card) !important; border-bottom: 1px solid var(--border); }
        .nav-tabs { border-bottom: 1px solid var(--border); display: flex; flex-wrap: nowrap; overflow-x: auto; }
        .nav-link { color: #8b949e; border: none !important; font-size: 0.85rem; }
        .nav-link.active { background: transparent !important; color: var(--accent) !important; border-bottom: 3px solid var(--accent) !important; font-weight: bold; }
        .editor { background: #000 !important; color: var(--neon) !important; font-family: monospace; height: 300px; border: 1px solid var(--border); font-size: 13px; }
        .wiki-guide { background: rgba(88,166,255,0.05); border-left: 4px solid var(--accent); padding: 12px; margin-top: 15px; font-size: 0.85rem; }
        .log-stream { height: 180px; overflow-y: scroll; font-size: 11px; color: #8b949e; font-family: monospace; background: #000; padding: 10px; border: 1px solid var(--border); }
    </style>
</head>
<body>

<nav class="navbar navbar-dark py-2 sticky-top">
    <div class="container d-flex justify-content-between align-items-center">
        <span class="navbar-brand fw-bold">🛡️ UK247 MASTER</span>
        <div class="d-flex gap-1">
            <a href="?action=stop_bot" class="btn btn-sm btn-danger">STOP</a>
            <a href="?action=start_bot" class="btn btn-sm btn-success px-3">RUN</a>
        </div>
    </div>
</nav>

<div class="container mt-3">
    <?php if($msg): ?> <div class="alert alert-primary border-0 bg-primary text-white py-2 mb-3 shadow"><?php echo $msg; ?></div> <?php endif; ?>

    <form method="POST">
        <ul class="nav nav-tabs mb-3" id="botTabs" role="tablist">
            <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#proxies" type="button">PROXIES</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#streams" type="button">STREAMS</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#agents" type="button">USER AGENTS</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#logic" type="button">LOGIC</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#logs" type="button">LOGS</button></li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade show active" id="proxies">
                <textarea name="proxy_data" class="form-control editor"><?php echo htmlspecialchars($proxies); ?></textarea>
                <div class="wiki-guide"><strong>Guide:</strong> Input <code>IP:PORT</code> per line. These provide the unique global identities for your listeners.</div>
            </div>

            <div class="tab-pane fade" id="streams">
                <textarea name="stream_data" class="form-control editor"><?php echo htmlspecialchars($streams); ?></textarea>
                <div class="wiki-guide"><strong>Guide:</strong> Enter direct audio endpoints (MP3/AAC). Ensure these are raw stream links, not player pages.</div>
            </div>

            <div class="tab-pane fade" id="agents">
                <textarea name="agent_data" class="form-control editor"><?php echo htmlspecialchars($agents); ?></textarea>
                <div class="wiki-guide">
                    <h5>📖 User Agent Intelligence</h5>
                    <p>I have prepopulated this box with <strong>10 Demo User Agents</strong> including Windows, Mac, Linux, iPhone, Android, Chrome, and Firefox strings.</p>
                    <strong>Purpose:</strong> By rotating these, the stream provider sees a mix of mobile and desktop users rather than a single bot signature.
                </div>
            </div>

            <div class="tab-pane fade" id="logic">
                <div class="bg-black p-3 rounded border border-secondary mb-3 text-center">
                    <div class="row g-2">
                        <div class="col-3"><label class="small text-secondary d-block">Min L</label><input type="number" name="min_L" class="form-control form-control-sm bg-dark text-white border-secondary text-center" value="<?php echo $config['min_L']; ?>"></div>
                        <div class="col-3"><label class="small text-secondary d-block">Max L</label><input type="number" name="max_L" class="form-control form-control-sm bg-dark text-white border-secondary text-center" value="<?php echo $config['max_L']; ?>"></div>
                        <div class="col-3"><label class="small text-secondary d-block">Min D</label><input type="number" name="min_D" class="form-control form-control-sm bg-dark text-white border-secondary text-center" value="<?php echo $config['min_D']; ?>"></div>
                        <div class="col-3"><label class="small text-secondary d-block">Max D</label><input type="number" name="max_D" class="form-control form-control-sm bg-dark text-white border-secondary text-center" value="<?php echo $config['max_D']; ?>"></div>
                    </div>
                </div>
                <div class="wiki-guide">
                    <h5>⚙️ Parameter Definitions</h5>
                    <p><strong>Min/Max Listeners (L):</strong> The bot picks a random target within this range per stream to maintain natural audience fluctuation.</p>
                    <p><strong>Min/Max Delay (D):</strong> This is the <strong>Staggered Delay</strong>. It sets how many seconds the bot waits before attempting to add the next listener, preventing a "spike" that looks automated.</p>
                </div>
            </div>

            <div class="tab-pane fade" id="logs">
                <div class="row g-3">
                    <div class="col-md-6"><span class="small fw-bold text-accent">✅ SUCCESS LOG</span><div class="log-stream"><?php echo nl2br(htmlspecialchars(shell_exec("tail -n 12 {$files['success']} 2>&1") ?: "No successful hits.")); ?></div></div>
                    <div class="col-md-6"><span class="small fw-bold text-danger">❌ FAILED LOG</span><div class="log-stream"><?php echo nl2br(htmlspecialchars(shell_exec("tail -n 12 {$files['failed']} 2>&1") ?: "No failures yet.")); ?></div></div>
                </div>
            </div>
        </div>

        <div class="mt-4 pb-4">
            <button type="submit" name="save_all" class="btn btn-primary w-100 py-3 fw-bold">💾 COMMIT CHANGES & SAVE PRESETS</button>
            <div class="text-center mt-3 small">
                <a href="?action=fix_perms" class="text-secondary text-decoration-none">🛠 REPAIR PERMS</a> | 
                <a href="/guide.html" target="_blank" class="text-info text-decoration-none">📖 WIKI MANUAL</a>
            </div>
        </div>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>