<?php
/**
 * STREAM BOT - DYNAMIC VERSION
 * Linked to Admin Panel CRUD & Logic
 */

// ==== 1. ENVIRONMENT SETUP ==== //
ini_set('max_execution_time', 0); // No timeout for bot process
set_time_limit(0);
error_reporting(E_ALL);
ini_set('display_errors', 0); // Keep browser clean, log to file
ini_set('log_errors', 1);

$baseDir = "/home/uk247mediahost";
ini_set('error_log', $baseDir . "/cron_error.log");

// ==== 2. LOAD DATA FROM ADMIN PANEL ==== //
// Load Configuration Logic
$config = json_decode(@file_get_contents("$baseDir/bot_config.json"), true) ?: [
    'min_L' => 20, 'max_L' => 50, 'min_D' => 60, 'max_D' => 300
];

// Load Streams
$streams = @file("$baseDir/streams.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [];

// Load User Agents
$userAgents = @file("$baseDir/user_agents.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) Chrome/91.0.4472.124 Safari/537.36"
];

// Load Proxies (Prioritize Tested Working List)
if (file_exists("$baseDir/working_proxies.txt") && filesize("$baseDir/working_proxies.txt") > 0) {
    $proxies = file("$baseDir/working_proxies.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
} else {
    $proxies = @file("$baseDir/proxies.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [];
}

// Safety Check
if (empty($streams) || empty($proxies)) {
    file_put_contents($baseDir . "/cron_error.log", date("Y-m-d H:i:s") . " - Error: Missing Streams or Proxies.\n", FILE_APPEND);
    die("System not configured. Update via Admin Panel.");
}

// ==== 3. EXECUTION LOGIC ==== //
$targetListeners = rand($config['min_L'], $config['max_L']);
$durations = [600, 900, 1800, 3600]; // 10m to 1hr sessions

foreach ($streams as $url) {
    for ($i = 0; $i < $targetListeners; $i++) {
        
        $proxy = $proxies[array_rand($proxies)];
        $agent = $userAgents[array_rand($userAgents)];
        $sessionTime = $durations[array_rand($durations)];
        
        // Background cURL Connection
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_PROXY, $proxy);
        curl_setopt($ch, CURLOPT_USERAGENT, $agent);
        curl_setopt($ch, CURLOPT_TIMEOUT, $sessionTime);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        
        // Executing in background
        curl_exec($ch);
        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($status == 200) {
            file_put_contents("$baseDir/successful_connections.log", date("H:i:s")." | Success | $proxy -> $url\n", FILE_APPEND);
        }

        // Apply staggering delay from Admin Settings
        sleep(rand($config['min_D'], $config['max_D']));
    }
}